#ifndef __MAKE_GRID_H__

#define __MAKE_GRID_H__
// ConsoleApplication3.cpp : Defines the entry point for the console application.
//

#include <iostream>
#include <string>
#include <vector>
#include <stdio.h>
#include <map>
#include <fstream>
#include "helper.h"
#include "Graph.h"

//using namespace std;

const double salt=0.00000001;

struct gridCell{
	int noBlackhole;
	int noVolcano;
	int BlackholeresidualFlow;
	int VolcanoresidualFlow;
	map<int,int> _Edge;
	map<int,int> _Node;

	gridCell() {
		noBlackhole = noVolcano = BlackholeresidualFlow = VolcanoresidualFlow = 0;
		_Edge.clear();
		_Node.clear();
	}
};

double Rad(double d);

double Geodist(double lat1, double lon1, double lat2, double lon2);

struct GridCellDistributor
{
	double colLength, rowLength;
	double minLat, minLong;
	GridCellDistributor(double minLat, double maxLat, double minLong, double maxLong, int NumGridCellcol, int NumGridCellrow) : minLat(minLat), minLong(minLong) {
		colLength = Geodist(maxLat, 0, minLat, 0) / NumGridCellcol;
		rowLength = Geodist(maxLong,0,minLong,0) / NumGridCellrow;
	}
	void findGridCell(int &i, int &j, double _lat, double _long) const {
		i = Geodist(_lat, 0, minLat, 0) / (colLength * 1.0000000001);
		j = Geodist(_long, 0, minLong, 0) / (rowLength * 1.0000000001);
	}
};


void initializeGridCell(vector<vector<gridCell>>& GC,int NumGridCellrow,int NumGridCellcol);

void findDomainSizeAndInsertNodes(FILE * pFile,double& maxLat,double& maxLong,double& minLat,double& minLong,int  numNode,map<int,vertex>& Nodes);

void findGridCell(int& i,int& j,double maxLat,double maxLong,double minLat,double minLong,int NumGridCellcol,int NumGridCellrow,double _lat,double _long);

void putNodesIntoGridCell(double maxLat,double maxLong,double minLat,double minLong,int NumGridCellcol,int NumGridCellrow,map<int,vertex>& Nodes,vector<vector<gridCell>>& GC);

void putEdgesIntoGridCell(FILE * pFile,double maxLat,double maxLong,double minLat,double minLong,int NumGridCellcol,int NumGridCellrow,map<int,vertex>& Nodes,vector<vector<gridCell>>& GC,int numEdge);

void makeGrid(char* RdNetworkFileName,vector<vector<gridCell>>& Grid,Graph& g,double areaThreshold,double& maxLat,double& maxLong,double& minLat,double& minLong);

#endif